//
//  CRStoryboardViewController.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 2/8/12.
//  Copyright (c) 2012 Sladki Programi d.o.o. All rights reserved.
//

@class CRStoryboardController;

//////////////////////////////////////////////////////////////////////
// Base controller for a Storyboard step page
//////////////////////////////////////////////////////////////////////
@interface CRStoryboardViewController : NSViewController
{
	NSSize originalSize;
}

@property (assign)	 CRStoryboardController* rootController;
@property (readonly) NSSize originalSize;
@property (readonly) BOOL adjustSize;
@property (readonly) BOOL supportsFullscreen;
@property (readonly) BOOL supportsResize;

- (NSMutableDictionary *)storyData;

- (void)willActivate;
- (void)activate;
- (void)viewActivated;

- (void)deactivate;

- (IBAction)goForward:(id)sender;
- (IBAction)goBackward:(id)sender;
- (IBAction)closeStory:(id)sender;

- (void)restoreOriginalSize;
- (void)requestPageSize:(NSSize)size;

@end